/******************************************************************************\
**
**     COMPANY:	LDW Software
**
**      MODULE:	ContentMapEditor
**
** DESCRIPTION:	Editor for the content map
**
**      AUTHOR:	Adrian Francis
**
\******************************************************************************/

#ifndef CONTENTMAP_EDITOR_H
#define CONTENTMAP_EDITOR_H

/******************************************************************************\
** LIBRARY INCLUDES
\******************************************************************************/
#include "ldwTypes.h"
#include "EditorInterface.h"
#include "../World/ContentMap.h"

/******************************************************************************\
** CONSTANT DEFINITIONS
\******************************************************************************/

/******************************************************************************\
** CLASS DEFINITIONS
\******************************************************************************/
class CContentMapEditor : public IEditor
{
private:

	//class enumerations
	enum EMode
	{
		eMode_Select = 0,
		eMode_Edit,
		eMode_EditLayer,
		eMode_Erase,

		eMode_NumberOf
	};

	//class data
	bool						m_bShowBlocking;
	bool						m_bShowMaterials;
	bool						m_bShowObjects;
	bool						m_bShowHotSpots;
	bool						m_bShowRedirectors;

	bool						m_bSelectionIsBlocking;
	CContentMap::EMaterial		m_eSelectionMaterial;
	CContentMap::EObject		m_eSelectionObject;
	CContentMap::EHotSpot		m_eSelectionHotSpot;
	CContentMap::ERedirector	m_eSelectionRedirector;

	float						m_fContentMapAlpha;

	bool						m_bIsMouseDown;
	bool						m_bIsDragging;
	bool						m_bIsRectSelectionEnabled;
	ldwRect						m_sRect;

	EMode						m_eMode;

	//class methods
	//setup
	public:		CContentMapEditor(void);
	public:		void Reset();

	// process
	public:		void Draw();
	public:		const bool HandleKeyCharacter(const char cKey);
	public:		const bool HandleKeyDown(const int iKeyCode);
	public:		const bool HandleKeyUp(const int iKeyCode);
	public:		const bool HandleMouseDown(const ldwPoint sMousePos);
	public:		const bool HandleMouseUp(const ldwPoint sMousePos);
	public:		const bool HandleMouseMove(const ldwPoint sMousePos);

	// access
	private:	const char *GetModeName(const EMode eMode) const;
	public:		const char *GetMaterialName(const CContentMap::EMaterial eMaterial) const;
	public:		const char *GetObjectName(const CContentMap::EObject eObject) const;
	public:		const char *GetObjectEnumName(const CContentMap::EObject eObject) const;
	public:		const char *GetHotSpotName(const CContentMap::EHotSpot eHotSpot) const;
	public:		const char *GetRedirectorName(const CContentMap::ERedirector eRedirector) const;
};

/******************************************************************************\
** GLOBAL DECLARATIONS
\******************************************************************************/
extern CContentMapEditor		ContentMapEditor;

#endif

/******************************************************************************\
** END OF FILE
\******************************************************************************/